import json
from typing import Dict, Any, List
from tractor.mail.db import Database
from tractor.mail.models import TaskType
from tractor.yandex_services.directory import Directory


def stop_migration_impl(org_id: str, env: Dict[str, Any]) -> None:
    db: Database = env["db"]
    directory: Directory = env["directory"]
    domain: str = directory.get_domain()
    with db.make_connection() as conn:
        with conn.cursor() as cur:
            migrations = db.acquire_and_stop_migrations(org_id, cur)
            for migration in migrations:
                db.cancel_task(migration["prepare_task_id"], cur)
                stop_task_id = db.create_task(
                    TaskType.STOP,
                    org_id,
                    domain,
                    json.dumps(
                        {
                            "prepare_task_id": migration["prepare_task_id"],
                            "previous_migration_status": migration["previous_status"]
                        }
                    ),
                    cur,
                )
                db.attach_stop_task_to_migration(stop_task_id, org_id, migration["login"], cur)
