from tractor.util.dataclasses import construct_from_dict
from tractor.settings import DirectorySettings, TractorDBSettings
from tractor.settings import Settings as BaseSettings

from dataclasses import dataclass


@dataclass
class CreateMigrationSettings:
    file_size_limit: int = 1 * 1024 * 1024
    logins_limit: int = 200


@dataclass
class MethodsList:
    create_migration: CreateMigrationSettings


@dataclass
class MethodsSettings:
    disk: MethodsList
    mail: MethodsList


class Settings(BaseSettings):
    def __init__(self) -> None:
        super().__init__()
        self.directory = construct_from_dict(DirectorySettings, self.data.get("directory"))
        self.tractor_disk_db = construct_from_dict(TractorDBSettings, self.data.get("tractor_db"))
        self.methods: MethodsSettings = construct_from_dict(
            MethodsSettings, self.data.get("methods")
        )


def settings():
    if not hasattr(settings, "instance"):
        settings.instance = Settings()

    return settings.instance
