CREATE SCHEMA IF NOT EXISTS tractor_disk;

CREATE TYPE tractor_disk.external_drive_provider as enum (
  'google',
  'microsoft'
);

CREATE TYPE tractor_disk.user_migration_status as enum (
  'listing',
  'syncing',
  'canceling',
  'error',
  'success'
);

CREATE TYPE tractor_disk.task_type as enum (
  'list_task',
  'sync_task'
);

CREATE TYPE tractor_disk.task_worker_status as enum (
  'pending', -- Task pends completion: no worker has finished processing it (but some might have already started).
  'error',
  'success'
);

CREATE TABLE tractor_disk.external_secrets
(
    org_id text NOT NULL,
    domain text NOT NULL,
    provider tractor_disk.external_drive_provider NOT NULL,
    encrypted_secret bytea NOT NULL,

    CONSTRAINT pk_external_secrets PRIMARY KEY (org_id, provider)
);

CREATE TABLE tractor_disk.tasks
(
    task_id BIGSERIAL,
    org_id text NOT NULL,
    domain text NOT NULL,

    type tractor_disk.task_type NOT NULL,
    created_ts TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT NOW(),
    input jsonb NOT NULL DEFAULT '{}'::jsonb,
    canceled boolean NOT NULL DEFAULT false, -- User has requested cancelation. The task still has to be processed.

    -- The following fields are updated by the worker(s).
    worker_id text NOT NULL DEFAULT ''::text,
    worker_status tractor_disk.task_worker_status NOT NULL DEFAULT 'pending'::tractor_disk.task_worker_status,
    worker_ts TIMESTAMP WITH TIME ZONE DEFAULT NULL, -- If not NULL, the task has been picked up for processing at least once.
    worker_output jsonb NOT NULL DEFAULT '{}'::jsonb,

    CONSTRAINT pk_tasks PRIMARY KEY (task_id)
);

CREATE TABLE tractor_disk.user_migrations
(
    org_id text NOT NULL,
    login text NOT NULL,
    domain text NOT NULL,
    status tractor_disk.user_migration_status NOT NULL,
    error_reason text NOT NULL DEFAULT ''::text,

    list_task_id BIGINT NOT NULL,
    sync_task_ids BIGINT[] NOT NULL DEFAULT array[]::BIGINT[],

    CONSTRAINT pk_user_migrations PRIMARY KEY (org_id, login),
    CONSTRAINT fk_user_migrations_list_task_id FOREIGN KEY (list_task_id) REFERENCES tractor_disk.tasks (task_id)
);
