CREATE SCHEMA IF NOT EXISTS tractor_mail;

CREATE TYPE tractor_mail.user_migration_status as enum (
  'preparing',
  'initial_sync',
  'sync_newest',
  'error',
  'stopping',
  'stopped'
);

CREATE TYPE tractor_mail.task_type as enum (
  'prepare_task',
  'stop_task'
);

CREATE TABLE tractor_mail.tasks
(
    task_id BIGSERIAL,
    org_id text NOT NULL,
    domain text NOT NULL,

    type tractor_mail.task_type NOT NULL,
    created_ts TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT NOW(),
    input jsonb NOT NULL DEFAULT '{}'::jsonb,
    canceled boolean NOT NULL DEFAULT false, -- User has requested cancelation. The task still has to be processed.

    -- The following fields are updated by the worker(s).
    worker_id text NOT NULL DEFAULT ''::text,
    worker_status tractor.task_worker_status NOT NULL DEFAULT 'pending'::tractor.task_worker_status,
    worker_ts TIMESTAMP WITH TIME ZONE DEFAULT NULL, -- If not NULL, the task has been picked up for processing at least once.
    worker_output jsonb NOT NULL DEFAULT '{}'::jsonb,

    CONSTRAINT pk_tasks PRIMARY KEY (task_id)
);

CREATE TABLE tractor_mail.user_migrations
(
    org_id text NOT NULL,
    login text NOT NULL,
    domain text NOT NULL,
    status tractor_mail.user_migration_status NOT NULL,
    error_reason text NOT NULL DEFAULT ''::text,
    stats jsonb NOT NULL DEFAULT '{}'::jsonb,

    prepare_task_id BIGINT NOT NULL,
    stop_task_id BIGINT,

    CONSTRAINT pk_user_migrations PRIMARY KEY (org_id, login),
    CONSTRAINT fk_user_migrations_prepare_task_id FOREIGN KEY (prepare_task_id) REFERENCES tractor_mail.tasks (task_id),
    CONSTRAINT fk_user_migrations_stop_task_id FOREIGN KEY (stop_task_id) REFERENCES tractor_mail.tasks (task_id)
);
