#!/bin/bash

set -eo pipefail
# set -x

export ROOT=/volume
export USERS=$ROOT/users
export LIST=$ROOT/list
export LIST_DONE=$ROOT/list.done
export SYNC=$ROOT/sync
export SYNC_DONE=$ROOT/sync.done

[[ $ORG_ID && $ORG_DOMAIN && $SOURCE_DRIVE && $LIST_PARALLEL && $SYNC_PARALLEL ]] \
    || { echo "check env variables" 1>&2; exit 1; }

cd /app
make load-secret

if [[ -f "$USERS" ]] && [[ -d "$LIST" ]]; then
    cat "$USERS" | \
		xargs -n 1 -P $LIST_PARALLEL -I{} \
			bash -c '/app/list_user_data.py \
				--org-id "$ORG_ID" \
				--domain "$ORG_DOMAIN" \
				--source $SOURCE_DRIVE \
				--user {} \
				 > $LIST/{}.json; echo "{} done"'
    mkdir -p "$LIST_DONE"
    mv "$LIST"/* "$LIST_DONE"/
    rmdir "$LIST"
fi

if [[ -d "$LIST_DONE" ]] && [[ -d "$SYNC" ]]; then
    find "$LIST_DONE" -size +0 -type f -name '*.json.report' | \
		xargs -n 1 -P $SYNC_PARALLEL -I{} \
			bash -c '[[ ! -f "$SYNC"/$(basename {}).synced ]] && /app/main.py --plan_file={} --source $SOURCE_DRIVE && \
                touch "$SYNC"/$(basename {}).synced && \
                echo "{} done"'
    mkdir -p "$SYNC_DONE"
    mv "$SYNC"/* "$SYNC_DONE"/ || true
    rmdir "$SYNC"
fi
