#!/bin/bash

set -eo pipefail

ROOT=/volume

cd /app

[[ $ORG_ID && $ORG_DOMAIN && $SOURCE_DRIVE && $LISTING_ACCOUNT_EMAIL ]] \
    || { echo "check env variables" 1>&2; exit 1; }

/app/list_users.py \
		--org-id "$ORG_ID" \
		--service-account "$LISTING_ACCOUNT_EMAIL" \
		--domain "$ORG_DOMAIN" \
		--source $SOURCE_DRIVE \
		> "$ROOT"/users
