#!/usr/bin/env python3
import json

import sys

for line in sys.stdin:
    line = line.replace(": ", "")
    line = line.replace(" :", "")
    line = line.replace('\\"', "")

    try:
        j = json.loads(line)
    except:
        continue

    fields = {}
    fields["timestamp"] = j["@timestamp"]
    fields["level"] = j["levelStr"].lower()
    fields["message"] = j["message"].replace(" ", "_")
    fields["orgid"] = j["@fields"].get("org_id", "")
    fields["mime_type"] = j["@fields"].get("mimeType", "")
    fields["err_category"] = j["@fields"].get("err_category", "")

    parts = ["{}={}".format(k, v) for k, v in fields.items()]
    print("\t".join(parts))
