#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

PATH="/usr/sbin:/usr/bin:/sbin:/bin"
LOGFILE="/app/log/app.log"
PARSE_JSON_LOG="/app/monitoring/parse_json_log.py"
ts=$(date +%s)


timetail -n 60 -r '(\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2})' $LOGFILE | $PARSE_JSON_LOG | \
    awk -F $'\t' -v ts="$ts" '
    @include "/usr/share/yandex-mail-common/metrics-util.awk"

    {
        level = get_tskv_value($0, "level")
        message = get_tskv_value($0, "message")
        orgid = get_tskv_value($0, "orgid")
        err_category = get_tskv_value($0, "err_category")
        if (length(orgid) == 0) { orgid = "none" }

        if (length(level) > 0) # filter malformed entries
        {
            metrics[level"."message][orgid]++
        }

        if (message == "sync_error") {
            if (length(err_category) > 0) {
                metrics["sync.files.error_category."err_category][orgid]++
            }
            else {
                metrics["sync.files.error_category.unknown"][orgid]++
            }
        }
    }

    END {
        for (metric in metrics) {
            for (orgid in metrics[metric]) {
                print metric, metrics[metric][orgid], ts, orgid
            }
        }
    }

'
