#!/bin/bash

set -eo pipefail
set -x

export ROOT=/volume
export LIST_DONE=$ROOT/list.done

cd /app

[[ $ORG_ID && $ORG_DOMAIN && $SOURCE_DRIVE ]] \
    || { echo "check env variables" 1>&2; exit 1; }

rm -rf "$LIST_DONE"/*.report

find "$LIST_DONE" -size +0 -name '*.json' | \
    xargs -n 1 -P 20 -I {} \
        bash -c '/app/report.py \
            --org-id "$ORG_ID" \
            --domain "$ORG_DOMAIN" \
            --source $SOURCE_DRIVE \
            --only-owned \
            --org-data {} \
                > {}.report'
