#!/bin/bash

TRACTOR_DISK_SECRET_ID="sec-01fxqgnz5n7qw86sxqeab6rvt6"
TRACTOR_DISK_SECRET_VERSION_ID=$(ya vault get secret $TRACTOR_DISK_SECRET_ID --json | jq -r .secret_versions[0].version)

mkdir -p data

# directory
ya tool tvmknife get_service_ticket sshkey --src 2031677 --dst 2000204 > data/.directory.token

# passport
ya tool tvmknife get_service_ticket sshkey --src 2025680 --dst 224 > data/.blackbox.token

# disk
ya tool tvmknife get_service_ticket sshkey --src 2033617 --dst 2000060 > data/.disk.token

# mds
ya tool tvmknife get_service_ticket sshkey --src 2033617 --dst 2000272 > data/.mds_secret.token

# tractor_disk_db
ya vault get version $TRACTOR_DISK_SECRET_VERSION_ID -o pgpass > data/.pgpass && chmod 0600 data/.pgpass
ya vault get version $TRACTOR_DISK_SECRET_VERSION_ID -o versioned_keys > data/.tractor_versioned_keys
