#!/usr/bin/env python3

from base64 import b64decode, b64encode

from tractor.crypto import Fernet, VersionedKeyStorage

KEY_VERSIONS = {"1": "r2WIfHza4dUejLD6QHY3aKsoarwbdxJkwSHKgShaV4k="}

key_version_storage = VersionedKeyStorage(KEY_VERSIONS)

_fernet = Fernet(key_version_storage)


def encrypt(password):
    return b64encode(_fernet.encrypt(password.encode("utf8"))).decode("ascii")


def decrypt(encrypted):
    return _fernet.decrypt(b64decode(encrypted)).decode("utf8")


TEST_PASSWORD = "12345"
encrypted = encrypt(TEST_PASSWORD)
print(TEST_PASSWORD, "<- origin")
print(encrypted, "<- encrypted")
print(decrypt(encrypted), "<- decrypted")
