from tractor.yandex_services.blackbox import Blackbox, ORG_IDS_ATTR
from tractor_disk.settings import settings


class DiskPair:
    def __init__(self, user, create_src_disk, create_dst_disk):
        self.sync_settings = settings().sync
        self._validate(user)
        self.src_disk = create_src_disk(user["email"])
        self.dst_disk = create_dst_disk(user["uid"])

    def _validate(self, user):
        blackbox = Blackbox(settings().blackbox)
        userinfo = blackbox.userinfo(user["uid"])
        if not userinfo["uid"]["hosted"]:
            raise RuntimeError("not pdd user")
        if userinfo["uid"]["domain_ena"] != "1":
            raise RuntimeError("not active pdd user")
        if not self._userinfo_has_orgid(userinfo, user["org_id"]):
            raise RuntimeError("org_id does ont correspond to uid")
        if self.sync_settings.validate_domain:
            if userinfo["uid"]["domain"] != user["domain"]:
                raise RuntimeError(
                    "domain does not correspond to uid: {} != {}".format(
                        userinfo["uid"]["domain"], user["domain"]
                    )
                )
            if not self._userinfo_has_email(userinfo, user["email"]):
                raise RuntimeError("email does not correspond to uid")
        if self._truncate_login(userinfo["login"]) != user["login"]:
            raise RuntimeError("login does not correspond to uid")

    def _userinfo_has_email(self, userinfo, email):
        for addr in userinfo["address-list"]:
            if addr["validated"] and addr["address"] == email:
                return True
        return False

    def _userinfo_has_orgid(self, userinfo, org_id):
        return userinfo["attributes"][ORG_IDS_ATTR] == org_id

    def _truncate_login(self, login):
        if not "@" in login:
            return login
        pos = login.find("@")
        return login[:pos]
