from tractor_disk.common import NULL_STR


class GoogleFile:
    def __init__(self, data):
        self.data = data

    def id(self):
        return self.data.get("id", NULL_STR)

    def mime_type(self):
        return self.data.get("mimeType", NULL_STR)

    def md5_checksum(self):
        return self.data.get("md5Checksum", NULL_STR)

    def size(self):
        return self.data.get("size", NULL_STR)

    def path(self):
        # GoogleDrive Item doesn't have `path` field.
        # We should build it in our code.
        return self.data.get("path", NULL_STR)

    def owned_by_me(self):
        return self.data.get("ownedByMe", True)
