import os

DOWNLOAD_DIR = "data/downloaded"


class LocalDisk:
    def store_file(self, path, content):
        path = "{}/{}".format(DOWNLOAD_DIR, path)
        with open(path, "wb") as f:
            f.write(content)

    def create_folder(self, path):
        os.mkdir("{}/{}".format(DOWNLOAD_DIR, path))

    def folder_exists(self, path):
        return os.path.isdir("{}/{}".format(DOWNLOAD_DIR, path))

    def file_exists(self, path):
        return os.path.isfile("{}/{}".format(DOWNLOAD_DIR, path))
