#!/usr/bin/env python3

from tractor_disk.source_drive import get_create_drive_op, SourceDrive
from tractor_disk.yandex_disk import create_yandex_disk
from tractor_disk.google_drive import GoogleDrive
from tractor_disk.sync.sync_org import SyncOrgOp
import argparse
import os
import re

IMPORT_FILE = "/volume/active_task.json"


def get_workers_data():
    worker_num = 0
    workers_count = 1
    if not "DEPLOY_WORKLOAD_ID" in os.environ:
        return worker_num, workers_count
    match = re.fullmatch("workload-(\d+)-(\d+)", os.environ["DEPLOY_WORKLOAD_ID"])
    if not match:
        return worker_num, workers_count
    worker_num = int(match.group(1))
    workers_count = int(match.group(2))
    return worker_num, workers_count


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--plan_file", help="sync plan", default=IMPORT_FILE)
    parser.add_argument(
        "--source", help="source drive", choices=list(SourceDrive), type=SourceDrive.from_string
    )
    args = parser.parse_args()
    return args


if __name__ == "__main__":
    args = parse_args()
    if args.source:
        source = SourceDrive(args.source)
    else:
        source = SourceDrive(os.environ["SOURCE_DRIVE"])
    worker_num, workers_count = get_workers_data()
    sync_org_op = SyncOrgOp(
        create_yandex_disk, get_create_drive_op(source), worker_num, workers_count
    )
    sync_org_op(args.plan_file)
