import time

from tractor.logger import setup_logger
from tractor_disk.settings import settings
from tractor_disk.workers.coordinator import processes_finished_list_task
from tractor_disk.workers.env import make_env


def main():
    global_env = make_env()
    db = global_env["db"]
    logger = global_env["logger"]
    settings = global_env["settings"].coordinator
    sleep_period_in_seconds = settings.sleep_period_in_seconds
    sync_migrations_pagination_size = settings.sync_migrations_pagination_size
    while True:
        try:
            with db.make_connection() as conn:
                with conn.cursor() as cur:
                    migration, task = db.poll_listing_migration(cur)
                    if migration and task:
                        processes_finished_list_task(migration, task, global_env, cur)
            with db.make_connection() as conn:
                with conn.cursor() as cur:
                    db.process_finished_sync_migrations(cur, limit=sync_migrations_pagination_size)
        except Exception as e:
            logger.exception("polling error", exception=e)
        time.sleep(sleep_period_in_seconds)


if __name__ == "__main__":
    setup_logger(settings().logging)
    main()
