#!/usr/bin/env python3

import time

from tractor.logger import setup_logger
from tractor_disk.settings import settings
from tractor_disk.workers.env import Env, make_env, make_sync_task_env as make_task_env
from tractor_disk.workers.sync_worker import run_task, acquire_task


def main():
    global_env = make_env()
    settings = global_env["settings"]
    while True:
        task = try_acquire_task(global_env)
        if task:
            global_env["logger"].info(message="acquired sync task", task_id=task.task_id)
            process_task(task, global_env)
        else:
            global_env["logger"].info(message="no sync tasks acquired")
            time.sleep(settings.sync.worker_sleep_period_in_seconds)


def try_acquire_task(global_env: Env):
    logger = global_env["logger"]
    try:
        return acquire_task(global_env)
    except Exception as e:
        logger.exception("failed to acquire sync task", exception=e)


def process_task(task, global_env: Env):
    logger = global_env["logger"]
    try:
        task_env = make_task_env(task, global_env)
        if task_env:
            run_task(task, task_env)
    except Exception as e:
        logger.exception(
            "failed to process sync task",
            exception=e,
        )


if __name__ == "__main__":
    setup_logger(settings().logging)
    main()
