import httplib2
import msal

LOGIN_URL = "https://login.microsoftonline.com/"
SCOPES = ["https://graph.microsoft.com/.default"]


class Credentials:
    def __init__(self, secret, domain):
        authority = LOGIN_URL + domain
        self.app = msal.ConfidentialClientApplication(
            secret["client_id"], authority=authority, client_credential=secret["secret"]
        )
        self.scopes = SCOPES

    def get_token(self):
        result = self.app.acquire_token_silent(self.scopes, account=None)
        if not result:
            result = self.app.acquire_token_for_client(scopes=self.scopes)

        if "access_token" in result:
            return result["access_token"]
        else:
            raise Exception(
                "Failed to acquire token: {} {} {}".format(
                    result.get("error"),
                    result.get("error_description"),
                    result.get("correlation_id"),
                )
            )


class AuthorizedHttp(object):
    def __init__(self, credentials):
        self.credentials = credentials
        self.http = httplib2.Http()

    def close(self):
        self.http.close()

    def request(
        self,
        uri,
        method="GET",
        body=None,
        headers=None,
        redirections=httplib2.DEFAULT_MAX_REDIRECTS,
        connection_type=None,
        **kwargs
    ):
        request_headers = headers.copy() if headers is not None else {}
        request_headers.update(self._auth_headers())

        response, content = self.http.request(
            uri,
            method,
            body=body,
            headers=request_headers,
            redirections=redirections,
            connection_type=connection_type,
            **kwargs
        )
        return response, content

    def _auth_headers(self):
        return {"Authorization": "Bearer " + self.credentials.get_token()}
