from tractor_disk.common import NULL_STR

MS_FOLDER_MIME_TYPE_PLACEHOLDER = "ms-folder"


class OneDriveFile:
    def __init__(self, data):
        self.data = data

    def id(self):
        return self.data.get("id", NULL_STR)

    def mime_type(self):
        if "folder" in self.data:
            return MS_FOLDER_MIME_TYPE_PLACEHOLDER
        if "file" in self.data:
            return self.data["file"].get("mimeType", NULL_STR)
        return NULL_STR

    def md5_checksum(self):
        return NULL_STR

    def size(self):
        return self.data.get("size", NULL_STR)

    def path(self):
        # OneDrive Item doesn't have `path` field.
        # We should build it in our code.
        return self.data.get("path", NULL_STR)

    def owned_by_me(self):
        return self.data.get("ownedByMe", True)
