from pathlib import PurePath


class SyncFileOp:
    def __init__(self, disk_pair):
        self.disk_pair = disk_pair

    def __call__(self, file):
        dst_path = file["path"]
        if self.disk_pair.dst_disk.file_exists(dst_path):
            return False
        self._create_folders_if_needed(dst_path)
        if file["mimeType"] == self.disk_pair.src_disk.folder_mime_type():
            return False
        content = self.disk_pair.src_disk.download_file(file["id"])
        self.disk_pair.dst_disk.store_file(dst_path, content)
        return True

    def _create_folders_if_needed(self, file_path):
        file_path = PurePath(file_path)
        parents = list(reversed(file_path.parents))
        parents = parents[1:]  # Remove '.'
        for parent in parents:
            parent_str = str(parent)
            if not self.disk_pair.dst_disk.folder_exists(parent_str):
                self.disk_pair.dst_disk.create_folder(parent_str)
