#!/usr/bin/env python3

from tractor_disk.source_drive import get_drive_by_source, get_drive_secret, SourceDrive
import sys
import json
import argparse


def main():
    args = parse_args()
    user = args.user
    drive_cls = get_drive_by_source(args.source)
    user_disk = drive_cls(get_drive_secret(args.source), user)
    org_data = {}
    org_data[user] = {}
    org_data[user]["files"] = user_disk.get_files()
    org_data[user]["root_folder_id"] = user_disk.root_folder_id()
    print(json.dumps(org_data))


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--org-id", help="org id")
    parser.add_argument("--domain", help="org domain")
    parser.add_argument("--user", help="user name first letter")
    parser.add_argument(
        "--source",
        help="source drive",
        choices=list(SourceDrive),
        type=SourceDrive.from_string,
        required=True,
    )
    args = parser.parse_args()
    return args


if __name__ == "__main__":
    main()
