#!/usr/bin/env python3

import argparse
from tractor_disk.settings import settings
from tractor_disk.mds import MDSClient


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("stid", help="stid")
    args = parser.parse_args()

    mds = MDSClient(
        settings().mds.read_url,
        settings().mds.write_url,
        settings().mds.namespace,
        settings().mds.expire,
    )

    print(mds.download(args.stid).decode())


if __name__ == "__main__":
    main()
