#!/usr/bin/env python3

import json
import sys
import os


def main():
    ret = []
    for file in sys.stdin.read().split("\n"):
        if file.strip() == "":
            break
        print("processing file:", file, file=sys.stderr)
        data = load_org_data(file)
        if data == "":
            print("empty file:", file, file=sys.stderr)
            continue
            # return

        ret += data
    print(json.dumps(ret))


def load_org_data(file_path):
    if os.path.getsize(file_path) == 0:
        return ""
    with open(file_path, "r") as f:
        return json.load(f)


if __name__ == "__main__":
    main()
