#!/usr/bin/env python3
import json

import re
import sys

for line in sys.stdin:
    line = line.replace(": ", "")
    line = line.replace(" :", "")
    line = line.replace('\\"', "")

    try:
        j = json.loads(line)
    except:
        print("error", line, file=sys.stderr)

    yandex_login = j["@fields"]["uid"]
    file_id = j["@fields"]["file_id"]
    mime = j["@fields"]["mime_type"] if "mime_type" in j["@fields"] else ""

    print(
        yandex_login, file_id, mime, j["@timestamp"], j["message"].replace(" ", "_"), j["@fields"]
    )
