#!/usr/bin/env python3

import argparse
from tractor_disk.yandex_disk import create_yandex_disk
import json


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--uid", help="yandex user id", required=True)
    args = parser.parse_args()
    return args


PREFIX = "disk:"

if __name__ == "__main__":
    args = parse_args()

    disk = create_yandex_disk(args.uid)
    files = disk.files()
    files = [file.get("path")[len(PREFIX) :] for file in files]
    for file in sorted(files):
        print(file)
