from typing import Dict


class Stat:
    def __init__(self, total_count) -> None:
        self.synced_count = 0
        self.exists_count = 0
        self.error_count = 0
        self.error_category_count = {}
        self.total_count = total_count

    def synced(self):
        self.synced_count += 1

    def exists(self):
        self.exists_count += 1

    def error(self, category):
        self.error_category_count[category] = self.error_category_count.get(category, 0) + 1
        self.error_count += 1

    def get_processed(self) -> int:
        return self.synced_count + self.exists_count + self.error_count

    def get_total(self) -> int:
        return self.total_count

    def get(self) -> Dict[str, int]:
        return {
            "synced": self.synced_count,
            "exists": self.exists_count,
            "error": self.error_count,
            "error_category": self.error_category_count,
            "processed": self.get_processed(),
            "total": self.total_count,
        }
