# coding: utf-8
'''Fill users.is_here in maildb base on sharddb shards.users'''
from ora2pg.app import make_app, logged, Argument
from ora2pg.clean_shards_users import clean
from ora2pg.tools.find_master_helpers import find_sharddb


@logged
def main():
    ShardIds = Argument(
        'shard_ids',
        'IDs of shards you want to clean up',
        type_=int,
        metavar='SHARD_ID',
        nargs='*',
    )
    Workers = Argument(
        '--workers',
        help_='workers count default: 8',
        type_=int,
        default=8
    )
    args = make_app(__doc__, ShardIds, Workers).args

    clean(
        args=args,
        workers=args.workers,
        sharddb_dsn=find_sharddb(args),
        shard_ids=args.shard_ids,
    )


if __name__ == '__main__':
    main()
