"""Remove user metadata from Postgre"""


def clean_user(uid, dsn):
    from pymdb.operations import PurgeUser, PurgeContactsUser
    from pymdb.types import ContactsUserType
    from mail.pypg.pypg.common import transaction

    with transaction(dsn) as conn:
        PurgeUser(conn, uid)()
        PurgeContactsUser(conn, user_id=uid, user_type=ContactsUserType.passport_user)(force=True)
