from collections import namedtuple
from .paranoia import (  # noqa
    register_dest_user_in_pg,
    purge_dest_user,
    assert_can_clone_source_user,
    assert_can_clone_into_dest_user,
    NotSupportedUserError,
)
from .clone_user_data import clone_user_data as clone_user_data_


CloneConfig = namedtuple('CloneConfig', [
    'dest_shard_id', 'sharddb',
    'sharpei', 'mailhost',
    'blackbox',
    'mulcagate',
    'maildb_dsn_suffix',
    'huskydb',
])


def clone_user(source_user, dest_user, config, force=False, min_received_date=None, max_received_date=None):
    if not force:
        assert_can_clone_into_dest_user(dest_user, config)
    assert_can_clone_source_user(source_user, config)
    register_dest_user_in_pg(dest_user, config)
    purge_dest_user(dest_user, config)
    clone_user_data_(
        source_user=source_user,
        dest_user=dest_user,
        config=config,
        min_received_date=min_received_date,
        max_received_date=max_received_date,
    )
