from contextlib import contextmanager

from mail.pypg.pypg.common import readonly_repeatable_read_transaction as pg_rorr_transaction
from ora2pg.pg_get import get_user as get_pg_user
from ora2pg.transfer_data import get_user_in_endpoint, DbEndpoint


def disable_user_backups(user):
    user.backups = []
    user.restores = []
    user.backup_folders = []
    user.backup_box = []
    user.folders_to_backup = []
    user.tabs_to_backup = []


class PGSourceFetcher(object):
    def __init__(self, user, shard_id, pg_dsn, min_received_date, max_received_date):
        self.user = user
        self.shard_id = shard_id
        self.pg_dsn = pg_dsn
        self.min_received_date = min_received_date
        self.max_received_date = max_received_date

    def user_in_endpoint(self):
        return get_user_in_endpoint(
            db_endpoint=DbEndpoint.make_pg(self.shard_id),
            uid=self.user.uid
        )

    @contextmanager
    def fetch(self):
        with pg_rorr_transaction(self.pg_dsn) as pg_conn:
            user = get_pg_user(
                uid=self.user.uid,
                conn=pg_conn,
                min_received_date=self.min_received_date,
                max_received_date=self.max_received_date,
            )
            disable_user_backups(user)
            yield user
