from ora2pg import storage, mime_xml as MX
from collections import namedtuple

import logging

log = logging.getLogger(__name__)


StidWithMime = namedtuple('StidWithMime', ['st_id', 'mime_xml', 'mime'])


class STIDsCopier(object):
    def __init__(self, mulcagate, user, cache=None):
        self._cache = cache or {}
        self.mulcagate = mulcagate
        self.user = user

    def _do_copy(self, st_id):
        try:
            raw_data = self.mulcagate.get_raw_data(st_id=st_id)
            mime_xml, message = storage.split_mime_xml_and_message(raw_data)
            mime = MX.parse_mime_xml(mime_xml)
            new_st_id = self.mulcagate.put(base_id=self.user, data=message)
            self._cache[st_id] = StidWithMime(new_st_id, mime_xml, mime)
        except storage.StorageError:
            log.exception(
                'Fail while try copy st_id %r - use same st_id', st_id)
        except MX.MimeXmlError:
            log.exception(
                'Fail while try copy st_id %r, bad mime xml - use same st_id', st_id)

    def copy(self, st_id):
        if st_id not in self._cache:
            self._do_copy(st_id)
        return self._cache.get(st_id, StidWithMime(st_id, None, None))
