from mail.pypg.pypg.common import qexec, fetch_as_dicts
from mail.pypg.pypg.query_conf import load_from_package
from ora2pg import mime_xml as MX
from psycopg2 import Binary
from .stids_copier import StidWithMime

Q = load_from_package(__package__, __file__)


class STIDsCopierCache(object):
    CHUNK_SIZE = 512

    def __init__(self, conn, uid):
        self.conn = conn
        self.uid = uid
        self._chunk = []
        self._cache = {}
        self._fetch_stids_copies()

    def _fetch_stids_copies(self):
        cur = qexec(self.conn, Q.get_st_ids_copies, uid=self.uid)
        for r in fetch_as_dicts(cur):
            mime_xml = r['mime_xml']
            if mime_xml is not None:
                # got read-only buffer
                mime_xml = str(mime_xml)
            self._cache[r['st_id']] = StidWithMime(
                st_id=r['new_st_id'],
                mime_xml=mime_xml,
                mime=MX.parse_mime_xml(mime_xml)
            )

    def _store_chunk(self):
        qexec(
            self.conn,
            Q.store_st_ids_copies,
            uid=self.uid,
            copies=self._chunk
        )
        self._chunk = []

    def store(self):
        if self._chunk:
            self._store_chunk()

    def __contains__(self, key):
        return key in self._cache

    def __getitem__(self, key):
        return self._cache[key]

    def get(self, key, default=None):
        return self._cache.get(key, default)

    def __setitem__(self, key, value):
        self._cache[key] = value
        self._chunk.append((key, value.st_id, Binary(value.mime_xml)))
        if len(self._chunk) > self.CHUNK_SIZE:
            self._store_chunk()
