def disable_filter_without_type(flt, types):
    """
    :type flt: pymdb.types.Filter
    :type types: list[pymdb.types.FilterActionOperType]
    :return: pymdb.types.Filter
    """
    if any((action.oper not in types) for action in flt.actions):
        flt.enabled = False
    return flt


def disable_filters_without_type(user, types):
    user.filters = list(map(lambda flt: disable_filter_without_type(flt, types), user.filters))


def enable_filter_without_type(flt, types):
    """
    :type flt: pymdb.types.Filter
    :type types: list[pymdb.types.FilterActionOperType]
    :return: pymdb.types.Filter
    """
    if any((action.oper not in types) for action in flt.actions):
        flt.enabled = True
    return flt


def enable_filters_without_type(user, types):
    user.filters = list(map(lambda flt: disable_filter_without_type(flt, types), user.filters))
