# coding: utf-8
import os


def check_oracle_env():
    for o_env in ['NLS_LANG', 'TNS_ADMIN']:
        assert \
            os.environ.get(o_env), \
            "Can't find {0} in environment `source /etc/oraprofile` first"


def is_currently_packaged():
    import pkg_resources
    try:
        pkg_resources.get_distribution("yamail_ora2pg")
        return True
    except pkg_resources.DistributionNotFound:
        pass
    return False
