from mail.pypg.pypg.common import transaction, simple_insert

from datetime import datetime

import logging

log = logging.getLogger(__name__)

TRANSFER_INFO_TABLE = 'transfer.info'


def write_transfer_info(dsn, uid, transfer_info):
    with transaction(dsn) as conn:
        transfer_info_dict = {
            'uid': uid,
            'from_db': str(transfer_info.src.db),
            'to_db': str(transfer_info.dst.db),
            'transfer_start': transfer_info.started,
            'transfer_end': datetime.now(),
            'script': transfer_info.script,
            'script_revision': transfer_info.script_revision,
            'transfer_host': transfer_info.transfered_at
        }
        try:
            cur = conn.cursor()
            cur.execute(
                simple_insert(TRANSFER_INFO_TABLE, transfer_info_dict.keys()),
                transfer_info_dict
            )
        except Exception as e:
            log.error('Failed to write transfer info into huskydb: %r', e)
