-- name: update_folders
INSERT INTO mail.folders AS f
  (uid, fid, revision, name, parent_fid, type, unvisited, unique_type, created,
   next_imap_id, uidvalidity, first_unseen, first_unseen_id,
   message_count, message_seen, message_size, message_recent, attach_count, attach_size,
   pop3state, position, subscribed_for_shared_folder)
VALUES (
   :uid, :fid, :revision, :name, :parent_fid, :type, :unvisited, :unique_type, :created,
   :next_imap_id, :uidvalidity, :first_unseen, :first_unseen_id,
   :message_count, :message_seen, :message_size, :message_recent, :attach_count, :attach_size,
   :pop3state, :position, :subscribed_for_shared_folder)
ON CONFLICT (uid, fid) DO UPDATE SET
  revision = excluded.revision,
  name = excluded.name,
  parent_fid = excluded.parent_fid,
  type = excluded.type,
  unvisited = excluded.unvisited,
  unique_type = excluded.unique_type,
  created = excluded.created,
  next_imap_id = excluded.next_imap_id,
  uidvalidity = excluded.uidvalidity,
  first_unseen = excluded.first_unseen,
  first_unseen_id = excluded.first_unseen_id,
  message_count = excluded.message_count,
  message_seen = excluded.message_seen,
  message_size = excluded.message_size,
  message_recent = excluded.message_recent,
  attach_count = excluded.attach_count,
  attach_size = excluded.attach_size,
  pop3state = excluded.pop3state,
  position = excluded.position,
  subscribed_for_shared_folder = excluded.subscribed_for_shared_folder

-- name: update_subscribed_folders
INSERT INTO mail.subscribed_folders AS sf
    (uid, fid, revision, owner_uid, owner_fid, subscription_id,
    synced_revision, created, synced_imap_id)
VALUES (
    :uid, :fid, :revision, :owner_uid, :owner_fid, :subscription_id,
    :synced_revision, :created, :synced_imap_id)
ON CONFLICT (uid, subscription_id) DO UPDATE SET
    fid = excluded.fid,
    revision = excluded.revision,
    owner_uid = excluded.owner_uid,
    owner_fid = excluded.owner_fid,
    synced_revision = excluded.synced_revision,
    created = excluded.created,
    synced_imap_id = excluded.synced_imap_id
