#!/usr/bin/env python
# coding: utf-8


class PgUser(object):
    __slots__ = (
        'user',
        'mailish_accounts',
        'mailish_auth_data',
        'folders',
        'mailish_folders',
        'tabs',

        'shared_folders',
        'shared_folder_subscriptions',
        'subscribed_folders',
        'synced_messages',
        'folder_archivation_rules',

        'labels',
        'imap_unsubscribed_folders',

        'filters',
        'filter_elists',

        'mails',
        'mailish_messages',
        'deleted_mails',

        'message_references',
        'threads_hashes',

        'counters',
        'attach_counters',

        'serials',

        'fix_log',

        'windat_messages',
        'settings',

        'passport_user_contacts_users',
        'passport_user_contacts_serials',
        'passport_user_contacts_lists',
        'passport_user_contacts_tags',
        'passport_user_contacts_contacts',
        'passport_user_contacts_emails',
        'passport_user_contacts_contacts_tags',
        'passport_user_contacts_emails_tags',
        'passport_user_contacts_shared_lists',
        'passport_user_contacts_subscribed_lists',

        'collectors',
        'stats_users_info',

        'backups',
        'restores',
        'backup_folders',
        'backup_box',
        'folders_to_backup',
        'tabs_to_backup',

        'archives',

        'stickers_reply_later',
    )

    def as_dict(self):
        return dict((k, getattr(self, k)) for k in self.__slots__)

    @property
    def data_version(self):
        if not hasattr(self, 'user'):
            return None
        return self.user.data_version

    @property
    def can_read_tabs(self):
        if not hasattr(self, 'user'):
            return None
        return self.user.can_read_tabs

    @property
    def is_deleted(self):
        if not hasattr(self, 'user'):
            return None
        return self.user.is_deleted

    @property
    def state(self):
        if not hasattr(self, 'user'):
            return None
        return self.user.state

    @property
    def last_state_update(self):
        if not hasattr(self, 'user'):
            return None
        return self.user.last_state_update

    @property
    def notifies_count(self):
        if not hasattr(self, 'user'):
            return None
        return self.user.notifies_count

    def __init__(self):
        # ora users don't have fix_log
        self.fix_log = []
        self.deleted_mails = []
