from mail.pypg.pypg import common as pg
from mail.pypg.pypg.query_conf import load_from_package
from pymdb.operations import RestoreDeleted, GetOrCreateFolder

Q = load_from_package(__package__, __file__)


def create_deleted_box_folder(mail_dsn, uid):
    with pg.transaction(mail_dsn) as conn:
        op = GetOrCreateFolder(conn, uid)
        op(name='deleted_box').commit()
        return op.fid


def restore_deleted_mails(mail_dsn, uid, mids, fid):
    with pg.transaction(mail_dsn) as conn:
        op = RestoreDeleted(conn, uid)
        op(mids=mids, fid=fid).commit()


def get_deleted_mids(mail_dsn, uid, start_mid, max_count):
    mids = []
    with pg.transaction(mail_dsn) as conn:
        cur = pg.qexec(
            conn=conn,
            query=Q.get_deleted_mids,
            uid=uid,
            start_mid=start_mid,
            max_count=max_count,
        )
        for md in pg.fetch_as_dicts(cur):
            mids.append(int(md['mid']))
    return mids


def get_deleted_mids_chunks(mail_dsn, uid, chunk_size):
    start_mid = 0
    chunk = get_deleted_mids(mail_dsn, uid, start_mid, chunk_size)
    while chunk:
        yield chunk
        start_mid = chunk[-1] + 1
        chunk = get_deleted_mids(mail_dsn, uid, start_mid, chunk_size)


def restore_deleted_box(mail_dsn, uid, chunk_size=100):
    fid = create_deleted_box_folder(mail_dsn, uid)
    for mids in get_deleted_mids_chunks(mail_dsn, uid, chunk_size):
        restore_deleted_mails(mail_dsn, uid, mids, fid)
