from mail.pypg.pypg import common as pg
from mail.pypg.pypg.query_conf import load_from_package
from pymdb.operations import MoveMessages
from .restore_deleted_box import create_deleted_box_folder

Q = load_from_package(__package__, __file__)


def restore_hidden_trash_mails(mail_dsn, uid, mids, fid):
    if len(mids) > 0:
        with pg.transaction(mail_dsn) as conn:
            op = MoveMessages(conn, uid)
            op(mids=mids, new_fid=fid, new_tab=None).commit()


def get_hidden_trash_fid(mail_dsn, uid):
    with pg.transaction(mail_dsn) as conn:
        cur = pg.qexec(
            conn=conn,
            query=Q.get_hidden_trash_fid,
            uid=uid,
        )
        return cur.fetchone()[0]


def get_hidden_trash_mids(mail_dsn, uid, hidden_trash_fid, max_count):
    while True:
        mids = []
        with pg.transaction(mail_dsn) as conn:
            cur = pg.qexec(
                conn=conn,
                query=Q.get_hidden_trash_mids,
                uid=uid,
                fid=hidden_trash_fid,
                max_count=max_count,
            )
            for md in pg.fetch_as_dicts(cur):
                mids.append(int(md['mid']))
        yield mids
        if len(mids) < max_count:
            break


def restore_hidden_trash(mail_dsn, uid, chunk_size=100):
    hidden_trash_fid = get_hidden_trash_fid(mail_dsn, uid)
    if hidden_trash_fid:
        fid = create_deleted_box_folder(mail_dsn, uid)
        for mids in get_hidden_trash_mids(mail_dsn, uid, hidden_trash_fid, chunk_size):
            restore_hidden_trash_mails(mail_dsn, uid, mids, fid)
