# coding: utf-8


def make_hdr_status(seen, forwarded, answered):
    """ Split recipients by ","

    >>> make_hdr_status(False, False, False)
    'New'
    >>> make_hdr_status(False, False, True)
    'New'
    >>> make_hdr_status(False, True, False)
    'New'
    >>> make_hdr_status(False, True, True)
    'New'
    >>> make_hdr_status(True, False, False)
    'RO'
    >>> make_hdr_status(True, False, True)
    'OQ'
    >>> make_hdr_status(True, True, False)
    'PL'
    >>> make_hdr_status(True, True, True)
    'PL'
    """
    if not seen:
        return 'New'
    if forwarded:
        return 'PL'
    if answered:
        return 'OQ'
    return 'RO'


if __name__ == '__main__':
    import doctest
    doctest.testmod()
