# coding: utf-8


class ImapPager(object):
    def __init__(self, folders):
        self.next_imap_ids = dict((f.fid, f.next_imap_id) for f in folders)

    def __call__(self, m):
        fid = m.coords.fid
        if fid not in self.next_imap_ids:
            self.next_imap_ids[fid] = 1
        imap_id = m.coords.imap_id
        if imap_id is None:
            self.next_imap_ids[fid] += 1
            return self.next_imap_ids[fid] - 1
        if imap_id >= self.next_imap_ids[fid]:
            self.next_imap_ids[fid] = imap_id + 1
        return imap_id
