# coding: utf-8
import json

from pymdb.operations import GetOrCreateTab, UpdateSettings
from pymdb.queries import Queries

DEFAULT_TAB = 'relevant'


def make_tabs_list(tabs_mapping):
    if tabs_mapping is None:
        return []

    all_tabs = [DEFAULT_TAB]
    for t in tabs_mapping:
        if t['type'] not in all_tabs:
            all_tabs.append(t['type'])
    return all_tabs


def create_tabs(conn, uid, tabs):
    if tabs is None:
        return []

    for tab in tabs:
        GetOrCreateTab(conn, uid)(tab)
    return Queries(conn, uid).tabs()


class LidTabMap(object):
    def __init__(self, lid_tab_map=None):
        self._lid_tab_map = lid_tab_map

    def __eq__(self, other):
        return self._lid_tab_map == other._lid_tab_map

    def __str__(self):
        return str(self._lid_tab_map)

    def get_tab(self, msg_lids, default=DEFAULT_TAB):
        if self._lid_tab_map is None:
            return None

        for lid, tab in self._lid_tab_map:
            if lid in msg_lids:
                return tab
        return default


def make_lid_tab_map(labels, tabs_mapping):
    if tabs_mapping is None:
        return LidTabMap(None)

    def find_label(lbl_list, so_type):
        return next((l for l in lbl_list if l.type == 'type' and l.name == so_type), None)

    lid_tab_map = []
    for t in tabs_mapping:
        lbl = find_label(labels, t['so_type'])
        if lbl:
            lid_tab_map.append((lbl.lid, t['type']))
    return LidTabMap(lid_tab_map)


def mark_user_as_can_read_tabs(conn, uid):
    cur = conn.cursor()
    cur.execute(
        '''UPDATE mail.users
              SET can_read_tabs = true
            WHERE uid = %(uid)s''',
        dict(uid=uid)
    )
    conn.wait()
    UpdateSettings(conn, uid)(
        json.dumps(dict(single_settings={'can_read_tabs': 'on'}))
    )
