#!/usr/bin/env python
# coding: utf-8

from mail.pypg.pypg import common as pg
from mail.pypg.pypg.query_conf import load_from_package

Q = load_from_package(__package__, __file__)
STID_COL_ID = 2


def get_one_chunk_from_queue(conn, uid, lower_stid, limit):
    return list(pg.qexec(
        conn=conn,
        query=Q.get_chunk_from_queue,
        uid=uid,
        lower_stid=lower_stid,
        max_count=limit,
    ))


def get_queue_chunks(conn, uid, chunk_size):
    cur_stid = ""
    chunk = get_one_chunk_from_queue(conn, uid, cur_stid, chunk_size)
    while chunk:
        yield chunk
        if len(chunk) == chunk_size:
            cur_stid = chunk[-1][STID_COL_ID]
            chunk = get_one_chunk_from_queue(conn, uid, cur_stid, chunk_size)
        else:
            chunk = None


def put_chunk_to_queue(conn, chunk):
    cur = conn.cursor()
    chunk_flatten = []
    for row in chunk:
        chunk_flatten += list(row)
    query_template = str(Q.put_chunk_to_queue).replace("%(chunk)s", ",".join(
        "(%s)" % ",".join("%s" for j in chunk[0]) for i in chunk
    ))
    query = cur.mogrify(query_template, chunk_flatten)
    cur.execute(query=query)


def remove_user_from_queue(conn, uid):
    pg.qexec(
        conn=conn,
        query=Q.remove_user_from_queue,
        uid=uid
    )


def transfer_delete_queue(from_pg_conn, dest_pg_dsn, uid, chunk_size=1000, remove_from_source=True):
    with pg.transaction(dest_pg_dsn) as dest_pg_conn:
        for chunk in get_queue_chunks(from_pg_conn, uid, chunk_size):
            put_chunk_to_queue(dest_pg_conn, chunk)
    if remove_from_source:
        remove_user_from_queue(from_pg_conn, uid)
