--- Maildb queries

-- name: set_migrate
SELECT code.transit_subscription_state(uid, subscription_id, 'migration') FROM (
    SELECT uid, subscription_id
      FROM mail.shared_folder_subscriptions
     WHERE uid = :uid
       AND state in ('sync', 'migrate-finished')
    ) f

-- name: set_sync
SELECT code.transit_subscription_state(uid, subscription_id, 'synchronization') FROM (
    SELECT uid, subscription_id
      FROM mail.shared_folder_subscriptions
     WHERE uid = :uid
       AND state in ('migrate', 'migrate-finished')
    ) f

-- name: update_subs_status
SELECT code.release_subscription(uid, subscription_id, worker_id) FROM (
    SELECT uid, subscription_id, worker_id
      FROM mail.shared_folder_subscriptions
     WHERE uid = :uid
       AND code.is_system_worker(worker_id)
    ) f
