PY23_LIBRARY()

OWNER(
    kremenkov
    g:mail
)

PY_SRCS(
    TOP_LEVEL

    ora2pg/__init__.py
    ora2pg/blackbox.py
    ora2pg/clean_shards_users.py
    ora2pg/cleanup.py
    ora2pg/compare.py
    ora2pg/conductor.py
    ora2pg/copy_user.py
    ora2pg/disable_filters.py
    ora2pg/duplicate.py
    ora2pg/errors.py
    ora2pg/helpers.py
    ora2pg/huskydb.py
    ora2pg/mime_xml.py
    ora2pg/pg_get.py
    ora2pg/pg_put.py
    ora2pg/reminders.py
    ora2pg/restore_deleted_box.py
    ora2pg/restore_hidden_trash.py
    ora2pg/sharpei.py
    ora2pg/storage.py
    ora2pg/sync_user.py
    ora2pg/transfer_data.py
    ora2pg/transfer_delete_queue.py
    ora2pg/transfer.py
    ora2pg/transfer_subscriptions.py

    ora2pg/app/__init__.py
    ora2pg/app/arguments.py
    ora2pg/app/code_version.py
    ora2pg/app/config_file.py
    ora2pg/app/helpers.py
    ora2pg/app/logs.py
    ora2pg/app/transfer_app.py

    ora2pg/clone_user/__init__.py
    ora2pg/clone_user/clone_user_data.py
    ora2pg/clone_user/paranoia.py
    ora2pg/clone_user/source_user_fetcher.py
    ora2pg/clone_user/stids_copier_cache.py
    ora2pg/clone_user/stids_copier.py

    ora2pg/tools/__init__.py
    ora2pg/tools/find_master_helpers.py
    ora2pg/tools/hdr_status.py
    ora2pg/tools/http.py
    ora2pg/tools/imap_pager.py
    ora2pg/tools/recipients.py
    ora2pg/tools/tabs.py
    ora2pg/tools/unicode_helpers.py

    ora2pg/pg_types/__init__.py
    ora2pg/pg_types/mail.py
    ora2pg/pg_types/user.py
)

PEERDIR(
    contrib/python/colorlog
    contrib/python/dateutil
    contrib/python/future
    contrib/python/psycopg2
    # blackbox, mime_xml
    contrib/python/lxml
    library/python/deprecated/ticket_parser2
    # pytz.utc
    contrib/python/pytz

    library/python/resource

    mail/pypg
    mail/pg/mdb/python
)

IF (PYTHON2)
    PEERDIR(contrib/python/typing)
ENDIF()

RESOURCE_FILES(
    mail/transfer/ora2pg/clean_shards_users.sql
    mail/transfer/ora2pg/pg_put.sql
    mail/transfer/ora2pg/sharpei.sql
    mail/transfer/ora2pg/restore_deleted_box.sql
    mail/transfer/ora2pg/restore_hidden_trash.sql
    mail/transfer/ora2pg/transfer_delete_queue.sql
    mail/transfer/ora2pg/transfer_subscriptions.sql

    mail/transfer/ora2pg/clone_user/stids_copier_cache.sql

    mail/transfer/ora2pg/configs/corp.yaml
    mail/transfer/ora2pg/configs/load.yaml
    mail/transfer/ora2pg/configs/prod.yaml
    mail/transfer/ora2pg/configs/test.yaml
    mail/transfer/ora2pg/configs/testing.yaml
    mail/transfer/ora2pg/configs/devpack.yaml
)

END()

RECURSE(
    bin
    ora2pg/tests/common
    ora2pg/clone_user/test/helpers
)

RECURSE_FOR_TESTS(
    # Unit
    ora2pg/tests
    ora2pg/app/tests
    ora2pg/clone_user/test
    ora2pg/tools/test
    # Integration
    tests
)
