# -*- coding: utf-8 -*-
import argparse
import logging

from sandbox.projects.mail.CommonLib.lib.qloud import QloudApi
from library.python.vault_client.instances import Production as VaultClient
from mail.transversal.web_api_component import WebApiComponent

target_environment_id = 'mail.verstka-qa.ub-template'


def main():
    parser = argparse.ArgumentParser()

    parser.add_argument('stand', help='Test stand name')
    parser.add_argument('--secret', '-s', help='YAV item', default='sec-01d34s477p8fak79sq374swfqa')
    parser.add_argument('--platform', '-p', help='Platform url', default='https://platform.yandex-team.ru')
    parser.add_argument('--backend', '-b', help='Backend', action='append', default=[])
    parser.add_argument('--url', '-u', help='Url', action='append', default=[])

    args = parser.parse_args()
    stand = 'stand-{}'.format(args.stand)

    vault = VaultClient(decode_files=True)
    secret = vault.get_version(args.secret)
    qloud_api = QloudApi(args.platform, secret['value']['platform.oauth.token'], logging.getLogger('QloudApi'))

    qloud_api.fork_environment(stand, target_environment_id)

    web_api_component = WebApiComponent(qloud_api, secret['value']['sandbox.oauth.token'],
                                        'mail.verstka-qa.{}.web-api'.format(stand))
    web_api_component.add_config(getConfig(args))

    qloud_api.deploy_environment('mail.verstka-qa.{}'.format(stand))


def getConfig(args):
    backends = args.backend
    urls = args.url

    backends_count = min(len(backends), len(urls))
    config = {}

    for index in range(backends_count):
        config[backends[index]] = urls[index]

    return config


if __name__ == '__main__':
    main()
