from yalibrary.upload.uploader import Uploader

import json


class WebApiComponent(object):
    def __init__(self, qloud_api, sandbox_token, component_id):
        self._qloud_api = qloud_api
        self._sandbox_token = sandbox_token
        self._component_id = component_id
        self._component = None

    @property
    def component(self):
        if self._component is None:
            self._component = self._qloud_api.get_component(self._component_id).json()

        return self._component

    def add_config(self, config_overrides):
        component_data = self._get_root_params()
        component_data["secrets"] = self._get_component_secrets()
        component_data["properties"] = self._get_component_properties()
        component_data["sandboxResources"] = self._add_config(config_overrides)

        self._qloud_api.modify_component(self._component_id, json.dumps(component_data))

    def _get_root_params(self):
        return {
            key: self.component[key]
            for key in [
                "instanceGroups", "statusHookChecks", "overlays", "embedJugglerClient", "jugglerBundleResources",
                "componentFeatures", "stopAction", "tvmConfig", "l3Config", "prepareRecipe", "activateRecipe"
            ]
        }

    def _get_component_secrets(self):
        secrets = []

        for secret in self.component["secrets"]:
            if secret["used"]:
                secrets.append({"used": True, "target": secret["target"], "objectId": secret["objectId"]})

        return secrets

    def _get_component_properties(self):
        return {
            key: self.component[key]
            for key in [
                "repository", "hash", "size", "profiles", "upstreamPort", "useDockerUserGroup", "isolationUser",
                "isolationGroup", "diskSize", "diskSerial", "ediskSize", "tmpfsDiskSize", "storage", "ioLimit",
                "allocationStrategy", "deployPolicy", "deployType", "allocationFailThreshold", "network", "dnsNat64",
                "unistat", "unistatPort", "unistatPath", "stdout", "stderr", "componentEnvironment", "useHealthCheck",
                "healthCheckType", "healthCheckHttpUrl", "healthCheckHttpExpectedCode", "healthCheckFall",
                "healthCheckRise", "healthCheckInterval", "healthCheckTimeout", "failTimeout", "maxFails", "useHttps",
                "notResolveServerName"
            ]
        }

    def _add_config(self, config_overrides):
        config = {"services": {key: {"url": value} for (key, value) in config_overrides.items()}}

        uploader = Uploader()

        resource_id = uploader.upload_str(json.dumps(config), resource_type='DISK_COMPRESSED_RESOURCE_APPLICATION',
                                          resource_arch='any', resource_description='Web Api Config',
                                          resource_owner='MAIL', resource_attrs='', ttl=14,
                                          sandbox_url='https://sandbox.yandex-team.ru',
                                          sandbox_token=self._sandbox_token)

        resources = self.component["sandboxResources"]

        resources.append({
            "description": "Web Api Config",
            "type": "DISK_COMPRESSED_RESOURCE_APPLICATION",
            "id": resource_id,
            "localName": "str",
            "symlink": "/etc/yamail/u2709-conf.json-prestable",
            "dynamic": False,
            "extract": False
        })

        return resources
