#pragma once

#include <string>

namespace tvm_guard::detail {

template<class Ticket>
struct TicketTraits {
    static bool ticketIsSuccessful(const Ticket& ticket);

    static std::string issuerUid(const Ticket& ticket);

    static bool issuerUidIsEmpty(const Ticket& ticket);

	static boost::optional<std::string> defaultUid(const Ticket& ticket);
};

template <class T>
std::string toString(const T& value) {
    return std::string(std::begin(value), std::end(value));
}

inline std::string&& toString(std::string&& value) {
    return std::move(value);
}

inline const std::string& toString(const std::string& value) {
    return value;
}

}
