#pragma once

#include <ostream>
#include <tvm_guard/types.h>
#include <tvm_guard/guard.h>
#include <boost/algorithm/string/join.hpp>


namespace tvm_guard {

inline std::string toString(tvm_guard::Reason reason) {
    switch (reason) {
        case tvm_guard::Reason::rule:
            return "rule";
        case tvm_guard::Reason::rootServiceTicket:
            return "root_service_ticket";
        case tvm_guard::Reason::wrongServiceTicket:
            return "wrong_service_ticket";
        case tvm_guard::Reason::wrongUserTicket:
            return "wrong_user_ticket";
        case tvm_guard::Reason::defaultPolicy:
            return "default_policy";
        case tvm_guard::Reason::ruleDefaultPolicy:
            return "rule_default_policy";
        case tvm_guard::Reason::unknownService:
            return "unknown_service";
        case tvm_guard::Reason::uidsMismatch:
            return "uids_mismatch";
        case tvm_guard::Reason::rootServiceTicketWithoutUid:
            return "root_service_ticket_without_uid";

        default:
            throw tvm_guard::StrangeReasonError(reason);
    }
}

inline std::string join(const std::set<tvm_guard::ClientId>& s) {
    std::vector<std::string> strs;
    std::transform(s.begin(), s.end(), std::back_inserter(strs),
                   [](const auto& i) {return std::to_string(i); });

    return boost::algorithm::join(strs, ",");
}

}

