#pragma once

#include <tvm_guard/types.h>
#include <ymod_webserver/request.h>
#include <ymod_webserver/server.h>

namespace tvm_guard {

struct Module {
    using Handler = std::function<void(ymod_webserver::response_ptr)>;
    using Handler2 = std::function<void(ymod_webserver::response_ptr, Response)>;

    virtual ~Module() { }

    virtual Response check(const ymod_webserver::request& req) const = 0;
    virtual void bind(ymod_webserver::server& server, const std::string& name,
                      const std::vector<std::string>& paths, Handler handler) const = 0;
    virtual void bind(ymod_webserver::server& server, const std::string& name,
                      const std::vector<std::string>& paths, Handler2 handler) const = 0;
};
using ModulePtr = std::shared_ptr<Module>;

}
